//
//  Chap4.h
//  Sinc
//
//  Created by 杉浦 洋 on 2018/03/31.
//  Copyright © 2018年 杉浦 洋. All rights reserved.
//

#ifndef Chap4_h
#define Chap4_h
/*--------------------------------------------------*/
/*［４］FTab,chi2Tab,tTab,zTab　　　　　　　　 　 　　　　*/
/*--------------------------------------------------*/
double FFun(int l,int m,double al){
    /*自由度(l,m)のF分布生存関数FCDF(t,l,m) = 1-al の解*/
    double eps=1.0e-8;
    if(l<1||m<1||al<eps||al>0.5)return NAN;
    return SecantHayter(FCDF,l,m,al);
};
double** FTab(int k,int m,double al){/* FFun(l,m,al)のT1型2次元表配列の出力 */
    return MakeTabT1t(FFun,k,m,al);
};
double chi2Fun(int l,double al){
    /*自由度lのχ自乗分布分布関数chi2CDF(t,l) = 1-al の解*/
    double eps=1.0e-8;
    if(l<1||al<eps||al>0.5)return NAN;
    return Secantt(chi2CDF,l,al);
};
double chi2FunTab(int l,int m,double al){/*表配列作成用chi2Fun：入力引数mはダミー*/
    double eps=1.0e-8;
    if(l<1||al<eps||al>0.5)return NAN;
    return Secantt(chi2CDF,l,al);
};
double** chi2Tab(int k,double al){/* FFun(l,al)のT1型2次元表配列の出力 */
    return MakeTabT1t(chi2FunTab,k,-1,al);
};
double tFun(int m,double al){
    /*自由度mのt分布分布関数tCDF(t,m) = 1-al の解*/
    double eps=1.0e-8;
    if((m<2&&m!=-1)||al<eps||al>0.5)return NAN;
    return Secantt(tCDF,m,al);
};
double tFunTab(int k,int m,double al){/*表配列作成用tFun：入力引数kはダミー*/
    double eps=1.0e-8;
    if((m<2&&m!=-1)||al<eps||al>0.5)return NAN;
    return Secantt(tCDF,m,al);
};
double** tTab(int k,int m,double al){/* FFun(l,al)のT1型2次元表配列の出力 */
    return MakeTabT1td(tFunTab,k,m,al);
};
double zFun(double al){
    /*標準正規分布分布関数PhiCDF(t,m) = 1-al の解*/
    double eps=1.0e-8;
    if(al<eps||al>0.5)return NAN;
    return Secantt(tCDF,-1,al);
};
double** zTab(int k,double al){/* FFun(l,al)のT1型2次元表配列の出力 */
    return MakeTabT1td(tFunTab,k,-1,al);
};
#endif /* Chap4_h */
